$(document).ready(function(){
	//clicks

	$(document).on('click', '#users', function(e){
		e.preventDefault();

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: {'page':'admin', 'action':'users', 'function':'userAction'},
			beforeSend: function(){
				$('#response').html('<span class="text text-info fw-bold">Fetching Users..  <span class="spinner-border spinner-border-sm"></span></span>');
			},
			success: function(e){
				$('#response').html(e)
			}
		})
	})

	$(document).on('click', '#classes', function(e){
		e.preventDefault();

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: {'page':'admin', 'action':'classes', 'function':'classesAction'},
			beforeSend: function(){
				$('#response').html('<span class="text text-info fw-bold">Fetching Classes..  <span class="spinner-border spinner-border-sm"></span></span>');
			},
			success: function(e){
				$('#response').html(e)
			}
		})
	})

	$(document).on('click', '#showUsers', function(e){
		e.preventDefault();

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: {'page':'admin', 'action':'users', 'function':'showUsers'},
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-info fw-bold">Fetching Users..  <span class="spinner-border spinner-border-sm"></span></span>');
			},
			success: function(e){
				$('#userContainer').html(e);
				$('#errMsg').html('');
			}
		})
	})

	$(document).on('click', '#addUserForm', function(e){
		e.preventDefault();

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: {'page':'admin', 'action':'users', 'function':'addUserForm'},
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-info fw-bold">Fetching Forms..  <span class="spinner-border spinner-border-sm"></span></span>')
			},
			success: function(e){
				$('#userContainer').html(e);
				$('#errMsg').html('');
			}			
		})
	})

	$(document).on('click', '#showClasses', function(e){
		e.preventDefault();

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: {'page':'admin', 'action':'classes', 'function':'viewClasses'},
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-info fw-bold">Fetching Users..  <span class="spinner-border spinner-border-sm"></span></span>');
			},
			success: function(e){
				$('#classesContainer').html(e);
				$('#errMsg').html('');
			}
		})
	})

	$(document).on('click', '#showSubjects', function(e){
		e.preventDefault();

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: {'page': 'admin', 'action': 'classes', 'function': 'viewSubjects'},
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-info fw-bold">Fetching Subjects..  <span class="spinner-border spinner-border-sm"></span></span>');
			},
			success: function(e){
				$('#classesContainer').html(e)
				$('#errMsg').html('')
			}
		})
	})

	$(document).on('click', '.close', function(){
		$('#mymodal').modal('hide');
	})

	$(document).on('click', '.del', function(e){
		e.preventDefault();

		var ID = $(this).attr('id')

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: {'page': 'admin', 'action': 'classes', 'function': 'classAction', 'classID':ID},
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-info fw-bold">Fetching Subjects..  <span class="spinner-border spinner-border-sm"></span></span>');
			},
			success: function(e){
				$('#errMsg').html(e)
			}
		})
	})

	$(document).on('click', '.delete', function(e){
		e.preventDefault();
		
		var subjectID = $(this).attr('id');

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: {'page': 'admin', 'action': 'classes', 'function': 'deleteSubject', 'subjectID': subjectID},
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-info fw-bold">Deleting Subject..  <span class="spinner-border spinner-border-sm"></span></span>');
			},
			success: function(e){
				$('#errMsg').html(e)
			}
		})
	})
	
	$(document).on('click', '.edit', function(e){
		e.preventDefault();
		
		var ID = $(this).attr('id');

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: {'page': 'admin', 'action': 'classes', 'function': 'editClassForm', 'ID': ID},
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-info fw-bold">Fetching Data..  <span class="spinner-border spinner-border-sm"></span></span>');
			},
			success: function(e){
				$('#errMsg').html('');
				$('#mymodal').html(e).modal('show');
			}
		})
	})

	//exam Clicks
	$(document).on('click', '#exams', function(e){
		e.preventDefault();

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: {'page':'admin', 'action':'exams', 'function':'examAction'},
			beforeSend: function(){
				$('#response').html('<span class="text text-info fw-bold">Fetching Exams..  <span class="spinner-border spinner-border-sm"></span></span>');
			},
			success: function(e){
				$('#response').html(e)
			}
		})
	})
	
	$(document).on('click', '.openExam', function(e){
		e.preventDefault();
		
		var examID = $(this).attr('dataID');
		// $('#examData').html(examID);

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: {'page':'admin', 'action':'exams', 'function':'examProfile', 'examID':examID},
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-info fw-bold">Fetching Exam..  <span class="spinner-border spinner-border-sm"></span></span>')
			},
			success: function(e){
				$('#errMsg').html('')
				$('#examRows').html(e)
			}
		})
	})

	$(document).on('click', '#addExamSubjects', function(e){
		e.preventDefault();

		var examID = $(this).attr('examID');

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: {'page':'admin', 'action':'exams', 'function':'showSubjectForm', 'examID':examID},
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-info fw-bold">Fetching Exam..  <span class="spinner-border spinner-border-sm"></span></span>')
			},
			success: function(e){
				$('#errMsg').html('')
				$('#examSectionManipulation').html(e)
			}
		})
	})

	$(document).on('click', '#subjectExamBtn', function(){
		var subjectID = $(this).attr('subjectID');
		var examID = $(this).attr('examID');

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: {'page':'admin', 'action':'exams', 'function':'showSubjectExamTable', 'examID':examID, 'subjectID':subjectID},
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-info fw-bold">Fetching Exam..  <span class="spinner-border spinner-border-sm"></span></span>')
			},
			success: function(e){
				$('#errMsg').html('')
				$('#examSectionManipulation').html(e)
			}
		})
	})

	$(document).on('click', '#viewExams', function(e){
		e.preventDefault();

		var parts = $(this).attr('totalParts');
		var sectionID = $(this).attr('sectionID');
		var subjectID = $(this).attr('subjectID');

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: {'page': 'admin', 'action': 'exams', 'function':'addPartsQuestion', 'parts':parts, 'sectionID':sectionID, 'subjectID':subjectID},
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-info fw-bold">Get Exam Form..  <span class="spinner-border spinner-border-sm"></span></span>')
			},
			success: function(e){
				$('#errMsg').html('')
				$('#examSectionManipulation').html(e)
			}
		})
	})

	$(document).on('click', '#examPart', function(e){
		e.preventDefault();

		var sectionPartID = $(this).attr('sectionPartID');
		var sectionID = $(this).attr('sectionID');

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: {'page':'admin', 'action':'exams', 'function':'showQuestions', 'sectionPartID':sectionPartID, 'sectionID':sectionID},
			beforeSend: function(){
				$('#partsDiv').html('<span class="text text-info fw-bold">Fetching Questions Data..  <span class="spinner-border spinner-border-sm"></span></span>')
			},
			success: function(e){
				$('#partsDiv').html(e)
			}
		})
	})

	//submit

	$(document).on('submit', '#addUsersForm', function(e){
		e.preventDefault();
		
		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: $(this).serialize(),
			// data: FormData,
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-success fw-bold">Adding Users..  <span class="spinner-border spinner-border-sm"></span></span>')
			},
			success: function(e){
				$('#errMsg').html(e)
			}
		});
	})

	$(document).on('submit', '#addClassForms', function(e){
		e.preventDefault();

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: $(this).serialize(),
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-success fw-bold">Adding Class..  <span class="spinner-border spinner-border-sm"></span></span>')
			},
			success: function(e){
				$('#errMsg').html(e)
			}
		})
	})

	$(document).on('submit', '#addSubjectForms', function(e){
		e.preventDefault();

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: $(this).serialize(),
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-info fw-bold">Adding Subjects..  <span class="spinner-border spinner-border-sm"></span></span>');
			},
			success: function(e){
				$('#errMsg').html(e)
			}
		})
	})

	$(document).on('submit', '#editClass', function(e){
		e.preventDefault()

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: $(this).serialize(),
			beforeSend: function(){
				$('#errResponse').html('<span class="text text-primary fw-bold">Editing..  <span class="spinner-border spinner-border-sm"></span></span>');
			},
			success: function(e){
				$('#errMsg').html(e)
				$('#mymodal').modal('hide')
			}
		})
	})

	$(document).on('submit', '.editSubject', function(e){
		e.preventDefault();

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: $(this).serialize(),
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-primary fw-bold">Editing Subject..  <span class="spinner-border spinner-border-sm"></span></span>');
			},
			success: function(e){
				$('#errMsg').html(e)
			}
		})
	})

	$(document).on('submit', '#addExam', function(e){
		e.preventDefault();

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: $(this).serialize(),
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-info fw-bold">Adding Exam..  <span class="spinner-border spinner-border-sm"></span></span>');
			},
			success: function(e){
				$('#errMsg').html('')
				$('#examData').html(e)
				// $('#errMsg').html(e)
			}
		})
	})

	$(document).on('submit', '#examSubjectForm', function(e){
		e.preventDefault();

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: $(this).serialize(),
			beforeSend: function(){
				$('#errMsg').html('<span class="text text-info fw-bold">Adding Exam..  <span class="spinner-border spinner-border-sm"></span></span>');
			},
			success: function(e){
				$('#errMsg').html(e)
			}
		})
	})

	$(document).on('submit', '#sectionTitleForm', function(e){
		e.preventDefault();

		$.ajax({
			url: "../inc/ajax_action.php",
			method: "POST",
			data: $(this).serialize(),
			beforeSend: function(){
				$('#partsDiv').html('<span class="text text-info fw-bold">Adding questions title..  <span class="spinner-border spinner-border-sm"></span></span>')
			},
			success: function(e){
				$('#partsDiv').html(e)
			}
		})
	})

})